import { Amplify } from 'aws-amplify';
import { PubSub } from '@aws-amplify/pubsub';
import amplifyconfig from './src/amplifyconfiguration.json';
Amplify.configure(amplifyconfig);

const pubsub = new PubSub({
  region: 'us-east-1',
  endpoint: 'wss://<IOT_CORE_ENDPOINT>/mqtt'
});

console.log(pubsub);

pubsub.subscribe({ topics: 'poker-advice' }).subscribe({
  next: (data) => {
    console.log('Message received', data);

    // 正規表現を使用してJSON文字列部分を抽出
    const jsonPartMatch = data.message.match(/{.*}/);
    if (!jsonPartMatch) {
      console.error('Valid JSON part not found in the message');
      return;
    }
    const jsonPart = jsonPartMatch[0];
    
    // 抽出したJSON文字列をパースしてオブジェクトを取得
    const messageObj = JSON.parse(jsonPart);
    const hand = messageObj.hand;
    const handName = messageObj.hand_name;

    // JSON部分を除いた残りのテキストをアドバイスとして使用
    const adviceText = data.message.replace(jsonPart, '').trim().replace(/\n/g, '<br>');

    updateHandAndAdvice(hand, handName, adviceText);
  },
  error: (error) => console.error(error),
  complete: () => console.log('Done')
});

function convertToUnicode(card) {
  const suits = {'♠': 'A', '♥': 'B', '♦': 'C', '♣': 'D'};
  const ranks = {
    'A': 1, '2': 2, '3': 3, '4': 4, '5': 5,
    '6': 6, '7': 7, '8': 8, '9': 9, '10': 10,
    'J': 11, 'Q': 12, 'K': 13
  };

  const suit = card[0];
  let rank = card.substring(1);

  let baseCode = 0x1F0A0; 
  if (suits[suit]) {
    baseCode += (suits[suit].charCodeAt(0) - 'A'.charCodeAt(0)) * 16;
  }

  if (ranks[rank] !== undefined) {
    let rankOffset = ranks[rank];
    if (rankOffset > 11) { 
      rankOffset += 1;
    }
    baseCode += rankOffset;
  }

  return String.fromCodePoint(baseCode);
}

// ハンドとアドバイスを更新する関数（アドバイステキスト追加）
function updateHandAndAdvice(hand, handName, adviceText) {
  const handElement = document.getElementById('hand');
  handElement.innerHTML = ''; // ハンド表示をリセット

  // ハンドのカードを追加
  hand.forEach(card => {
    const cardElement = document.createElement('div');
    cardElement.classList.add('card');
    if (card.startsWith('♥') || card.startsWith('♦')) {
      cardElement.classList.add('heart-diamond');
    }
    const unicodeCard = convertToUnicode(card);
    cardElement.textContent = unicodeCard;
    handElement.appendChild(cardElement);
  });

  // アドバイスを更新
  const adviceElement = document.getElementById('advice');
  adviceElement.innerHTML = `<p>🃏 ${handName}</p><p>💬 ${adviceText}</p>`;
}
