# 生成 AI x RAG x サーバーレスで実現！
# AWS AppSync Events と Amazon Bedrock Knowledge Bases で作るライブチャットモデレーション

React x Next.js を使用して構築された、シンプルなライブチャットアプリケーションです。

## 機能

- 最初のページでユーザー名を入力
- AWS AppSync Events サブスクリプションを使用したリアルタイムメッセージ表示
- シンプルなコメント形式：`<ユーザー名> コメント`
- 入力フィールドと送信ボタンでメッセージを送信
- 最新メッセージへの自動スクロール

## セットアップ

1. 依存関係をインストール：
```bash
npm install
```

2. `.env.local`に環境変数を設定：
```
NEXT_PUBLIC_APPSYNC_ENDPOINT=あなたのappsyncエンドポイント
NEXT_PUBLIC_AWS_REGION=あなたのawsリージョン
NEXT_PUBLIC_AUTH_MODE=apiKey
NEXT_PUBLIC_API_KEY=あなたのapiキー
```

3. 開発サーバーを起動：
```bash
npm run dev
```

4. ブラウザで[http://localhost:3000](http://localhost:3000)を開く

## 使用方法

1. 最初のページでユーザー名を入力
2. 「視聴する」をクリックしてチャットルームに入室
3. 入力フィールドにメッセージを入力し、「送信」をクリックするかEnterキーを押す
4. メッセージはすべての接続ユーザーにリアルタイムで表示されます

## アーキテクチャ

- **フロントエンド**: 状態管理にReactフックを使用したNext.js
- **リアルタイム**: ライブサブスクリプション用のAWS AppSync Events API
- **スタイリング**: シンプルで洗練されたUIのためのTailwind CSS
- **TypeScript**: アプリケーション全体での完全な型安全性

このアプリは`/chat/[ライブID]`チャンネルに接続し、すべての受信メッセージをリアルタイムで表示します。