/**
 * チャット参加ページコンポーネント
 * ユーザー名とライブIDを入力してチャットに参加するためのページ
 */
'use client';

// 必要なReactフックとコンポーネントのインポート
import { useState } from 'react';
// Next.jsのルーティング機能
import { useRouter } from 'next/navigation';

export default function JoinPage() {
  // ステート変数の定義
  const [username, setUsername] = useState(''); // ユーザー名
  const [liveId, setLiveId] = useState('f64f2f85-d5ac-429b-bac2-861fd029dcab'); // デフォルトのライブID
  const router = useRouter(); // ルーター

  /**
   * フォーム送信時の処理
   * ユーザー名とライブIDをローカルストレージに保存し、チャットページに遷移する
   * @param e フォームイベント
   */
  const handleUsernameSubmit = (e: React.FormEvent) => {
    e.preventDefault(); // デフォルトのフォーム送信動作を防止

    // ユーザー名とライブIDが入力されているか確認
    if (username.trim() && liveId.trim()) {
      // ローカルストレージに情報を保存
      localStorage.setItem('chatUsername', username);
      localStorage.setItem('chatLiveId', liveId);
      // チャットページにリダイレクト
      router.push('/');
    }
  };

  /**
   * UIレンダリング
   */
  return (
    <div className="min-h-screen bg-gray-100 flex items-center justify-center">
      {/* メインコンテナ */}
      <div className="bg-white p-8 rounded-lg shadow-md w-full max-w-md">
        {/* ページタイトル */}
        <h1 className="text-2xl font-bold text-center mb-6 text-gray-800">
          Live Chat
        </h1>
        {/* 参加フォーム */}
        <form onSubmit={handleUsernameSubmit}>
          {/* ユーザー名入力フィールド */}
          <div className="mb-4">
            <label htmlFor="username" className="block text-sm font-medium text-gray-700 mb-2">
              ユーザー名
            </label>
            <input
              type="text"
              id="username"
              value={username}
              onChange={(e) => setUsername(e.target.value)}
              className="w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-red-500"
              placeholder="ユーザー名を入力"
              required
            />
          </div>
          {/* ライブID入力フィールド */}
          <div className="mb-4">
            <label htmlFor="liveId" className="block text-sm font-medium text-gray-700 mb-2">
              ライブID
            </label>
            <input
              type="text"
              id="liveId"
              value={liveId}
              onChange={(e) => setLiveId(e.target.value)}
              className="w-full px-3 py-2 border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-red-500"
              placeholder="ライブIDを入力"
              required
            />
          </div>
          {/* 送信ボタン */}
          <button
            type="submit"
            className="w-full bg-red-500 text-white py-2 px-4 rounded hover:bg-red-600 focus:outline-none focus:ring-2 focus:ring-red-500"
          >
            視聴する
          </button>
        </form>
      </div>
    </div>
  );
}