'use client';

import { Message } from '../types/message';

interface MessageBubbleProps {
  message: Message;
}

export default function MessageBubble({ message }: MessageBubbleProps) {
  const formatTime = (timestamp: number) => {
    return new Date(timestamp).toLocaleTimeString([], {
      hour: '2-digit',
      minute: '2-digit'
    });
  };

  return (
    <div className="mb-2 py-1">
      <div className="flex items-start gap-2">
        <span className="font-semibold text-red-600">{message.username}</span>
        <div className="text-gray-800">
          {message.isRejected ? (
            <span className="text-gray-400 italic">{message.message}</span>
          ) : (
            <span>{message.message}</span>
          )}
        </div>
        <span className="text-xs text-gray-500 ml-auto">{formatTime(message.timestamp)}</span>
      </div>
    </div>
  );
}